<?php $__env->startSection('content-wrapper-header'); ?>
    <section class="content-header">
        <h1>
            Monthly Deposit Pending Request
        </h1>
        <ol class="breadcrumb">
            <li ><a href="/admin"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active"><a href="#">Pending Request List</a></li>
        </ol>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content">

        <div class="row">
            <div class="col-lg-12">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <?php echo e('Pending Request List'); ?>

                    </div>
                    <div class="panel-body">

                        <div class="table-responsive">
                            <table class=" table table-bordered table-striped table-hover datatable datatable-Project">
                                <thead>
                                <tr>
                                    <th width="10">

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.project.fields.id')); ?>

                                    </th>

                                    <th>
                                        <?php echo e("Deposited By"); ?>

                                    </th>

                                    <th>
                                        <?php echo e("Date"); ?>

                                    </th>

                                    <th>
                                        <?php echo e("Amount (Tk)"); ?>

                                    </th>
                                    <th>
                                        <?php echo e("Notes"); ?>

                                    </th>
                                    <th>
                                        <?php echo e("Bank Account Name"); ?>

                                    </th>
                                    <th>
                                        <?php echo e("Approval Status"); ?>

                                    </th>
                                    <th>
                                        &nbsp;<?php echo e("Actions"); ?>

                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $increment=1;
                                ?>

                                <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-entry-id="<?php echo e($deposit->id); ?>">
                                        <td>


                                        </td>
                                        <td>
                                            <?php echo e($increment); ?>

                                            <?php
                                                $increment++;
                                            ?>
                                        </td>
                                        <td>
                                            <?php if($deposit->deposited_by): ?>
                                                <a href="<?php echo e(route('admin.profile.show', $deposit->depositedBy->id)); ?>" target="_blank">
                                                    <?php echo e($deposit->depositedBy->name ?? ''); ?>

                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($deposit->date ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($deposit->amount ?? ''); ?>


                                        </td>
                                        <td>
                                            <?php echo e($deposit->description ?? ''); ?>

                                        </td>
                                        <td>
                                            
                                            <?php echo e(($deposit->bank_account->account_title ?? '')); ?>


                                        </td>
                                        <td>
                                            <?php if($deposit->is_approved): ?>
                                                <span class="label label-success label-many"><?php echo e("Approved"); ?></span>
                                            <?php elseif($deposit->is_approved == 0): ?>
                                                <span class="label label-warning label-many" ><?php echo e("Pending"); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrole_monthly_deposit_access')): ?>
                                                <a class="btn btn-xs btn-primary" href="<?php echo e(route('admin.monthly-deposits.show', $deposit->id)); ?>">
                                                    <?php echo e(trans('global.view')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrole_monthly_deposit_access')): ?>
                                                <?php if(!$deposit->is_approved): ?>
                                                    <a class="btn btn-xs btn-success" href="<?php echo e(route('admin.monthly-deposits.approve', $deposit->id)); ?>">
                                                        <?php echo e('Approve'); ?>

                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrole_monthly_deposit_access')): ?>
                                                <?php if(!$deposit->is_approved): ?>





                                                        <a class="btn btn-xs btn-danger" href="<?php echo e(route('admin.monthly-deposits.reject', $deposit->id)); ?>">
                                                            <?php echo e('Reject'); ?>

                                                        </a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script>
        $(function () {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_delete')): ?>
            let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "<?php echo e(route('admin.projects.massDestroy')); ?>",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

                        return
                    }

                    if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
                        $.ajax({
                            headers: {'x-csrf-token': _token},
                            method: 'POST',
                            url: config.url,
                            data: { ids: ids, _method: 'DELETE' }})
                            .done(function () { location.reload() })
                    }
                }
            }
            // dtButtons.push(deleteButton)
            <?php endif; ?>

            $.extend(true, $.fn.dataTable.defaults, {
                order: [[ 1, 'desc' ]],
                pageLength: 100,
            });
            $('.datatable-Project:not(.ajaxTable)').DataTable({ buttons: dtButtons })
            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e){
                $($.fn.dataTable.tables(true)).DataTable()
                    .columns.adjust();
            });
        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Adones\Downloads\Laravel System Project\MCS-Management-System-Laravel\resources\views/admin/monthlyDeposits/pendingRequest/index.blade.php ENDPATH**/ ?>