<?php $__env->startSection('content'); ?>
    <div class="content">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_create')): ?>
            <div style="margin-bottom: 10px;" class="row">
                <div class="col-lg-12">
                    <a class="btn btn-success" href="<?php echo e(route("admin.users.create")); ?>">
                        <?php echo e(trans('global.add')); ?> <?php echo e(trans('cruds.user.title_singular')); ?>

                    </a>
                </div>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <?php echo e(trans('cruds.user.title_singular')); ?> <?php echo e(trans('global.list')); ?>

                    </div>
                    <div class="panel-body">

                        <div class="table-responsive">
                            <table class=" table table-bordered table-striped table-hover datatable datatable-User">
                                <thead>
                                <tr>
                                    <th width="10">

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.id')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.image')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.name')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.email')); ?>

                                    </th>



                                    <th>
                                        <?php echo e(trans('cruds.user.fields.roles')); ?>

                                    </th>






                                    <th>
                                        <?php echo e(trans('cruds.user.fields.user_status')); ?>

                                    </th>
                                    <th>
                                        <?php echo e("Actions"); ?>

                                        &nbsp;
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-entry-id="<?php echo e($user->id); ?>">
                                        <td>

                                        </td>
                                        <td>
                                            <?php echo e($user->id ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php if($user->profile->profile_image): ?>
                                                <a href="<?php echo e(route('admin.profile.show', $user->profile->user_id)); ?>" target="_blank">
                                                    <img src="<?php echo e($user->profile->profile_image); ?>" width="60px"
                                                         height="60px" style="border-radius: 50%;">
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($user->name ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->email ?? ''); ?>

                                        </td>



                                        <td>
                                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="label label-info label-many"><?php echo e($item->title); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>














                                        <td>
                                            <?php if($user->status==1): ?>
                                                <b style="color:green"> Enable</b>
                                            <?php else: ?>
                                                <b style="color:red">  Disabled</b>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update_user_status')): ?>
                                                    <br>
                                                    <button id="showSelectDiv<?php echo e($user->id); ?>"
                                                            class="bbtn btn-dark">
                                                        Change status
                                                    </button>
                                                    <div class="btn btn-xs" id="selectDiv<?php echo e($user->id); ?>">
                                                        <input type="hidden" id="userID<?php echo e($user->id); ?>" value="<?php echo e($user->id); ?>">
                                                        <select class="bootstrap-select" id="loginStatus<?php echo e($user->id); ?>">
                                                            <option value="" selected >select a option</option>
                                                            <option value="1">Enable</option>
                                                            <option value="0">Disabled</option>
                                                        </select>
                                                    </div>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_show')): ?>
                                                <a class="btn btn-xs btn-primary"
                                                   href="<?php echo e(route('admin.users.show', $user->id)); ?>">
                                                    <?php echo e(trans('global.view')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_edit')): ?>
                                                <a class="btn btn-xs btn-info"
                                                   href="<?php echo e(route('admin.users.edit', $user->id)); ?>">
                                                    <?php echo e(trans('global.edit')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_delete')): ?>
                                                <form action="<?php echo e(route('admin.users.destroy', $user->id)); ?>"
                                                      method="POST"
                                                      onsubmit="return confirm('<?php echo e(trans('global.areYouSure')); ?>');"
                                                      style="display: inline-block;">
                                                    <input type="hidden" name="_method" value="DELETE">
                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <input type="submit" class="btn btn-xs btn-danger"
                                                           value="<?php echo e(trans('global.delete')); ?>">
                                                </form>
                                            <?php endif; ?>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script>

        $(function () {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_delete')): ?>
            let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "<?php echo e(route('admin.users.massDestroy')); ?>",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({selected: true}).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

                        return
                    }

                    if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
                        $.ajax({
                            headers: {'x-csrf-token': _token},
                            method: 'POST',
                            url: config.url,
                            data: {ids: ids, _method: 'DELETE'}
                        })
                            .done(function () {
                                location.reload()
                            })
                    }
                }
            }
            dtButtons.push(deleteButton)
            <?php endif; ?>

            $.extend(true, $.fn.dataTable.defaults, {
                order: [[1, 'desc']],
                pageLength: 100,
            });
            $('.datatable-User:not(.ajaxTable)').DataTable({buttons: dtButtons})
            $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
                $($.fn.dataTable.tables(true)).DataTable()
                    .columns.adjust();
            });
        })

        $(document).ready(function(){

            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            $("#selectDiv<?php echo e($user->id); ?>").hide();
            $("#showSelectDiv<?php echo e($user->id); ?>").click(function(){
                $("#selectDiv<?php echo e($user->id); ?>").show();
            });
            $("#loginStatus<?php echo e($user->id); ?>").change(function(){
                var status = $("#loginStatus<?php echo e($user->id); ?>").val();
                var userID = $("#userID<?php echo e($user->id); ?>").val();
                // alert("user Id" + userID + "Status " + status);
                if(status==""){
                    alert("please select an option");
                }else{
                    // alert("please select");
                    $.ajax({
                        headers: {'x-csrf-token': _token},
                        url: '<?php echo e(route("admin.users.banUser")); ?>',
                        
                        data: 'status=' + status + '&userID=' + userID,
                        type: 'get',
                        success:function(response){
                            console.log(response);
                        }
                    })
                        .done(function () {
                            location.reload()
                        })
                }

            });
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Adones\Downloads\MCS-Management-System-master\resources\views/admin/users/index.blade.php ENDPATH**/ ?>